/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.ammobench;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.common.init.ModRecipeSerializers;
import dev.toma.gunsrpg.common.init.ModRecipeTypes;
import dev.toma.gunsrpg.common.tileentity.AmmoBenchTileEntity;
import dev.toma.gunsrpg.resource.MultiIngredient;
import dev.toma.gunsrpg.resource.ammobench.AmmoBenchOutputModifier;
import dev.toma.gunsrpg.resource.util.ResourceUtils;
import dev.toma.gunsrpg.resource.util.conditions.ConditionType;
import dev.toma.gunsrpg.resource.util.conditions.IRecipeCondition;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class AmmoBenchRecipe
implements IRecipe<AmmoBenchTileEntity> {
    private final ResourceLocation recipeId;
    private final List<MultiIngredient> inputs;
    private final List<AmmoBenchOutput> outputs;
    private final int craftingTimer;
    private final List<IRecipeCondition> craftingConditions;

    public AmmoBenchRecipe(ResourceLocation recipeId, List<MultiIngredient> inputs, List<AmmoBenchOutput> outputs, int time, List<IRecipeCondition> craftingConditions) {
        this.recipeId = recipeId;
        this.inputs = inputs;
        this.outputs = outputs;
        this.craftingTimer = time;
        this.craftingConditions = craftingConditions;
    }

    public boolean matches(AmmoBenchTileEntity tile, World world) {
        return MultiIngredient.test(tile, AmmoBenchTileEntity.SLOT_INPUTS, this.inputs);
    }

    public ItemStack assemble(AmmoBenchTileEntity tile) {
        return ItemStack.field_190927_a;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public boolean canPlayerCraft(PlayerEntity player) {
        for (IRecipeCondition condition : this.craftingConditions) {
            if (condition.canCraft(player)) continue;
            return false;
        }
        return true;
    }

    public int getCraftingTimer() {
        return this.craftingTimer;
    }

    public List<MultiIngredient> getInputs() {
        return this.inputs;
    }

    public List<AmmoBenchOutput> getOutputs() {
        return this.outputs;
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeType<?> func_222127_g() {
        return ModRecipeTypes.AMMO_BENCH_RECIPE_TYPE;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeSerializers.AMMO_BENCH_RECIPE_SERIALIZER.get();
    }

    public boolean func_192399_d() {
        return true;
    }

    public static final class AmmoBenchOutput {
        private final ItemStack baseResult;
        private final List<AmmoBenchOutputModifier> outputModifiers;

        public AmmoBenchOutput(ItemStack baseResult, List<AmmoBenchOutputModifier> outputModifiers) {
            this.baseResult = baseResult;
            this.outputModifiers = outputModifiers;
        }

        public ItemStack getItemStack() {
            return this.baseResult;
        }

        public List<AmmoBenchOutputModifier> getOutputModifiers() {
            return this.outputModifiers;
        }

        public static AmmoBenchOutput fromJson(JsonObject json) throws JsonParseException {
            ItemStack item = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
            JsonArray modifiersJson = JSONUtils.func_151213_a((JsonObject)json, (String)"modifiers", (JsonArray)new JsonArray());
            List modifiers = JsonHelper.deserialize(modifiersJson, arr -> new ArrayList(arr.size()), AmmoBenchOutputModifier::parseJson, List::add);
            return new AmmoBenchOutput(item, modifiers);
        }

        public void encode(PacketBuffer buffer) {
            buffer.func_150788_a(this.baseResult);
            buffer.func_150787_b(this.outputModifiers.size());
            this.outputModifiers.forEach(mod -> mod.encode(buffer));
        }

        public static AmmoBenchOutput decode(PacketBuffer buffer) {
            ItemStack itemStack = buffer.func_150791_c();
            int limit = buffer.func_150792_a();
            ArrayList<AmmoBenchOutputModifier> modifiers = new ArrayList<AmmoBenchOutputModifier>();
            for (int i = 0; i < limit; ++i) {
                modifiers.add(AmmoBenchOutputModifier.decode(buffer));
            }
            return new AmmoBenchOutput(itemStack, modifiers);
        }
    }

    public static final class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AmmoBenchRecipe> {
        public AmmoBenchRecipe fromJson(ResourceLocation recipeId, JsonObject data) {
            JsonArray inputsJson = JSONUtils.func_151214_t((JsonObject)data, (String)"inputs");
            if (inputsJson.size() > AmmoBenchTileEntity.SLOT_INPUTS.length) {
                throw new JsonSyntaxException(String.format("Too many recipe inputs for ammo bench recipe %s. Got %d inputs, limit is %d", recipeId, inputsJson.size(), AmmoBenchTileEntity.SLOT_INPUTS.length));
            }
            JsonArray outputsJson = JSONUtils.func_151214_t((JsonObject)data, (String)"outputs");
            if (outputsJson.size() > AmmoBenchTileEntity.SLOT_OUTPUTS.length) {
                throw new JsonSyntaxException(String.format("Too many recipe outputs for ammo bench recipe %s. Got %d outputs, limit is %d", recipeId, outputsJson.size(), AmmoBenchTileEntity.SLOT_OUTPUTS.length));
            }
            JsonArray conditions = JSONUtils.func_151213_a((JsonObject)data, (String)"requirements", (JsonArray)new JsonArray());
            int timer = Math.max(1, JSONUtils.func_151208_a((JsonObject)data, (String)"craftingTimer", (int)100));
            List ingredients = JsonHelper.deserialize(inputsJson, arr -> new ArrayList(arr.size()), MultiIngredient::parseJson, List::add);
            List outputs = JsonHelper.deserialize(outputsJson, arr -> new ArrayList(arr.size()), el -> AmmoBenchOutput.fromJson(el.getAsJsonObject()), List::add);
            List<IRecipeCondition> conditionList = ResourceUtils.getConditionsFromJson(conditions);
            return new AmmoBenchRecipe(recipeId, ingredients, outputs, timer, conditionList);
        }

        @Nullable
        public AmmoBenchRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            int limit = buffer.func_150792_a();
            ArrayList<MultiIngredient> inputs = new ArrayList<MultiIngredient>();
            for (int i = 0; i < limit; ++i) {
                inputs.add(MultiIngredient.decode(buffer));
            }
            limit = buffer.func_150792_a();
            ArrayList<AmmoBenchOutput> outputs = new ArrayList<AmmoBenchOutput>();
            for (int i = 0; i < limit; ++i) {
                outputs.add(AmmoBenchOutput.decode(buffer));
            }
            int timer = buffer.readInt();
            limit = buffer.func_150792_a();
            ArrayList<IRecipeCondition> conditionList = limit != 0 ? new ArrayList<IRecipeCondition>() : Collections.emptyList();
            for (int i = 0; i < limit; ++i) {
                conditionList.add((IRecipeCondition)ConditionType.fromNetwork(buffer));
            }
            return new AmmoBenchRecipe(recipeId, inputs, outputs, timer, conditionList);
        }

        public void toNetwork(PacketBuffer buffer, AmmoBenchRecipe recipe) {
            buffer.func_150787_b(recipe.inputs.size());
            recipe.inputs.forEach(inp -> inp.encode(buffer));
            buffer.func_150787_b(recipe.outputs.size());
            recipe.outputs.forEach(out -> out.encode(buffer));
            buffer.writeInt(recipe.craftingTimer);
            buffer.func_150787_b(recipe.craftingConditions.size());
            recipe.craftingConditions.forEach(condition -> ConditionType.toNetwork(buffer, condition));
        }
    }
}

